Review

# Properties and Applications of PDMS for Biomedical Engineering: A Review

Inês Miranda 1, Andrews Souza ${ } ^ { 2 } \textcircled { \mathbb { D } }$ , Paulo Sousa ${ \bf 1 } _ { \textcircled { \mathbb { D } } }$ , João Ribeiro ${ } ^ { 3 } \textcircled { \mathbb { P } } _ { j }$ , Elisabete M. S. Castanheira ${ \mathfrak { 4 } } _ { \bigoplus }$ , Rui Lima $^ { 2 , 5 , * \oplus }$ and Graça Minas $\mathbf { 1 } _ { \textcircled { 1 } }$

Citation: Miranda, I.; Souza, A.; Sousa, P.; Ribeiro, J.; Castanheira, E.M.S.; Lima, R.; Minas, G. Properties and Applications of PDMS for Biomedical Engineering: A Review. J. Funct. Biomater. 2022, 13, 2. https:// doi.org/10.3390/jfb13010002

Academic Editors: Cristian Scheau, Andreea Didilescu and Constantin Caruntu

Received: 16 November 2021   
Accepted: 16 December 2021   
Published: 21 December 2021

Publisher’s Note: MDPI stays neutral with regard to jurisdictional claims in published maps and institutional affiliations.

Center for MicroElectromechanical Systems (CMEMS-UMinho), Campus de Azurém, University of Minho, 4800-058 Guimaraes, Portugal; ines_sofia_miranda@outlook.com (I.M.); psousa@dei.uminho.pt (P.S.); gminas@dei.uminho.pt (G.M.) 2 MEtRICs, Mechanical Engineering Department, Campus de Azurém, University of Minho, 4800-058 Guimaraes, Portugal; andrewsv81@gmail.com 3 Centro de Investigação de Montanha (CIMO), Campus de Santa Apolónia, Instituto Politécnico de Bragança, 5300-253 Braganca, Portugal; jribeiro@ipb.pt 4 Centre of Physics of Minho and Porto Universities (CF-UM-UP), Campus de Gualtar, University of Minho, 4710-057 Braga, Portugal; ecoutinho@fisica.uminho.pt 5 CEFT, Faculdade de Engenharia da Universidade do Porto (FEUP), Rua Roberto Frias, 4200-465 Porto, Portugal Correspondence: rl@dem.uminho.pt

Abstract: Polydimethylsiloxane (PDMS) is an elastomer with excellent optical, electrical and mechanical properties, which makes it well-suited for several engineering applications. Due to its biocompatibility, PDMS is widely used for biomedical purposes. This widespread use has also led to the massification of the soft-lithography technique, introduced for facilitating the rapid prototyping of micro and nanostructures using elastomeric materials, most notably PDMS. This technique has allowed advances in microfluidic, electronic and biomedical fields. In this review, an overview of the properties of PDMS and some of its commonly used treatments, aiming at the suitability to those fields’ needs, are presented. Applications such as microchips in the biomedical field, replication of cardiovascular flow and medical implants are also reviewed.

Keywords: polydimethylsiloxane; PDMS properties; PDMS applications; microfluidics; biomedical engineering

# 1. Introduction

Polydimethylsiloxane (PDMS) is an elastomeric polymer with interesting properties for biomedical applications, including physiological indifference, excellent resistance to biodegradation, biocompatibility, chemical stability, gas permeability, good mechanical properties, excellent optical transparency and simple fabrication by replica moulding [1–5]. Due to these characteristics, PDMS has been widely used in micropumps [6], catheter surfaces [7], dressings and bandages [8], microvalves [9], optical systems [10,11], in the in vitro study of diseases [12,13], in implants [14,15], in microfluidics and photonics [16–19]. Moreover, soft-lithography technology has driven the use of PDMS in microelectromechanical systems (MEMS) applications and in microfluidic components [17,18,20]. Soft-lithography techniques such as micro-contact printing, replica moulding, micro-transfer moulding, micro-moulding in capillaries and solvent-assisted micro-moulding usually require the use of PDMS to create an elastomeric stamp or mould that incorporates nano- and microstructures for the transfer of patterns onto a subsequent substrate [18,21].

MEMS are approaches that use electronic and mechanical technologies to deal with biomedical problems on the micro-scale [22]. MEMS-based devices have been widely used in the biomedical area for applications such as diagnostics and therapeutics. These systems can be microsensors or microtransducers, and are helpful in areas such as physics, mechanics, electronics and biomedicals, as they can provide very precise and fast results [23].

The investigation and improvement of already existing MEMS are more and more common. As they are increasingly commercialized, the necessity to find processes and materials that enable mass production while reducing cost has emerged [21]. MEMS are traditionally silicon-based and the pursuit for a more biologically friendly material is needed. Polymers allow rapid prototyping and mass production techniques as well as having a lower cost in relation to silicon, making them particularly attractive for the development of MEMS [21]. Photolithography is the most commonly used technique in microfabrication, however, this method is expensive [24]. With the introduction of polymers in microsystems, new manufacturing techniques have been studied, such as soft-lithography, which can be a cheaper method comparatively to photolithography, even when a costly mould is needed for patterning; once a mould is created, it can be reused several times [20]. Additionally, there are alternatives which are attempting to reduce the cost of the moulds, relying on cleanroom less approaches [25]. Candidate polymers for the production of MEMS are polycarbonate (PC), polymethylmethacrylate (PMMA), polyvinylchloride (PVC), polyethylene (PE) and PDMS [21].

Additionally, PDMS is the most commonly used material in the manufacturing of microfluidic devices, which are an important technology for the development of systems such as drug delivery, DNA sequencing, clinical diagnostics, point of care testing and chemical synthesis [26]. The used materials in these systems should be biocompatible, optically transparent and provide fast prototyping and low fabrication cost [27], features found in PDMS.

In addition to applications in microfluidics, PDMS has been widely used in the fabrication of biomodels (flow phantom) for the in vitro hemodynamic study of diseases such as aneurysms and stenosis [28–31]. The biomodels developed in PDMS allow good replicability of the lumen of the arteries and good transparency, being ideal for the application of optical techniques of micro particle image velocimetry (micro-PIV), particle image velocimetry (PIV), particle tracking velocimetry (PTV) and non-evasive techniques [32–34]. These experimental tests have provided a greater understanding of these pathologies, validated numerical techniques and tested medical devices such as stents [35–37].

PDMS has also been investigated in the field of medical implants [38–42]. These types of implants are usually made with titanium or its alloys; however, such materials do not allow a good osseointegration [39]. In order to overcome this limitation, PDMS has been studied to produce coatings with microscale features that help the bonding between the implant and the bone. The main characteristics for its use in implants are its high biocompatibility, excellent resistance to biodegradation and flexibility, which makes PDMS one of the most successful polymers in implanted devices, presenting only mild foreign body reactions [43–45]. Common applications include cardiac pacemakers, cuff and book electrodes in the PNS, cochlear implants, bladder and pain controllers and planar electrode arrays in the CNS [45,46].

In this review, research on PDMS properties, their fabrication processes and their characterization methods are reported. Moreover, their use in MEMS applications, microfluidics, medical implants and hemodynamic studies is investigated. Written in a concise, but complete manner, we believe that this manuscript joins together the main advantages, disadvantages and challenges of PMDS when biomedical applications are needed and, therefore, can be extremely useful for researchers looking to learn about this biomaterial and its applicability in this biomedical field.

# 2. PDMS Properties

Silicon, glass and polymers are the typical materials used for micro devices fabrication: silicon, because of its thermal conductivity and the availability of advanced fabrication technologies; glass, mainly due to its transparency; polymers, because of its low cost, optical transparency and flexibility. Compared to glass and silicon, PDMS turns out to be the most promising elastomer, because the other two materials have a high manufacturing cost, require greater labour intensity and are rigid in nature. The variable elasticity of PDMS in medical applications is also favourable; its modulus of elasticity is $1 { - } 3 \mathrm { M P a }$ (compared to ${ \sim } 5 0 \mathrm { G P a }$ of glass) [2,47]. PDMS is also chemically inert, thermally stable, permeable to gases, simple to handle and manipulate, exhibits isotropic and homogeneous properties and can replicate submicron features to develop microstructures [19,21,48]. Additionally, this elastomer is optically transparent, can work as a thermal and electrical insulator and degrades quickly in the natural environment [49]. PDMS presents a hyperelastic behaviour, which is the ability of a material to undergo large deformations before rupture [50]. This characteristic is also found in biological tissues and, for that reason, PDMS is a well-suited material to mimic, for example, blood vessels [49]. Another characteristic of this elastomer is its biocompatibility, which means that PDMS is compatible with biologic tissues [49]. PDMS presents a transmittance up to $9 0 \%$ for the wavelength from $3 9 0 \mathrm { n m }$ to $7 8 0 \mathrm { n m }$ [51–53] and, due to this characteristic, PDMS-based microsystems allow the direct observation of the mimicked blood flow inside the mimicked vessels and the integration of optical detection systems, hence playing an important role in this field.

With the purpose of extending the lifespan of a chip, PDMS is used to embed or encapsulate electronic components by casting. Due to its thermal and electrical insulation capability, PDMS protects the components from environmental factors and mechanical shock within a large temperature range $( - 5 0 { - } 2 0 0 \ ^ { \circ } \mathrm { C } )$ [23,48]. In Table 1, some physical properties of PDMS are listed.

Table 1. Typical properties of cured PDMS.   

<html><body><table><tr><td>Property (Unity)</td><td>Result</td><td>References</td></tr><tr><td>Transmittance at range 390 nm to 780 nm (%)</td><td>75-92</td><td>[54,55]</td></tr><tr><td>Index of refraction</td><td>1.4</td><td>[56]</td></tr><tr><td>Thermal conductivity (W/m·K)</td><td>0.2-0.27</td><td>[57,58]</td></tr><tr><td>Specific heat (kJ/kg·K)</td><td>1.46</td><td>[56]</td></tr><tr><td>Dielectric strength (kV/mm)</td><td>19</td><td>[57]</td></tr><tr><td>Dielectric constant</td><td>2.3-2.8</td><td>[56]</td></tr><tr><td>Electrical conductivity (ohm·m)</td><td>4×1013</td><td>[56]</td></tr><tr><td>Volume resistivity (ohm·cm)</td><td>2.9×1014</td><td>[57]</td></tr><tr><td>Young&#x27;s modulus [kPa]</td><td>360-870</td><td>[59]</td></tr><tr><td>Poisson ratio</td><td>0.5</td><td>[60]</td></tr><tr><td>Tensile strength (MPa)</td><td>2.24-6.7</td><td>[56,57]</td></tr><tr><td>Hardness [Shore A]</td><td>41-43</td><td>[55,61]</td></tr><tr><td>Viscosity (Pa·s)</td><td>3.5</td><td>[57]</td></tr><tr><td>Hydrophobicity—contact angle (°)</td><td>~108°±7°</td><td>[62]</td></tr><tr><td>Melting Point (C)</td><td>-49.9 to-40</td><td>[63]</td></tr></table></body></html>

Despite these advantages, PDMS has some properties that can present a limitation in some applications. Due to its $\mathrm { C H } _ { 3 }$ groups, PDMS presents a hydrophobic surface (contact angle with water ${ \sim } 1 0 8 ^ { \circ } \pm 7 ^ { \circ }$ ) [62,64,65], often limiting its application in solutions composed of biological samples [66]. Additionally, PDMS tends to swell when combined with certain reagents [17,48]. In some applications, the absorption of small molecules flowing through the channels makes it difficult to quantitatively analyse experiments in proteomic drug discovery and cell culture [67,68]. In microchannels, the hydrophobicity of PDMS generates complications that include impedance to the flow of polar liquids, which makes it difficult to wet its surface with aqueous solvents [49]. On the other hand, much effort has been made to make the PDMS surface hydrophilic and resistant to protein adsorption [19,69–73].

Strategies employed in attempting to solve PDMS hydrophobicity include surface activation methods such as: oxygen plasma; UV/ozone treatments; corona discharges, which are widely used for PDMS surface oxidation to promote microchannel wettability. The main benefits of these methods are the short treatment time and easy operation; however, the PDMS surface recovers its hydrophobicity when in contact with air within a few minutes [74–76]. The hydrophilic treatments and some examples are discussed further in Section 5.

Another method is physisorption, which is a simple and efficient approach that relies on surface hydrophobic or electrostatic interactions. This method includes the following techniques: layer-by-layer deposition; non-ionic surfactants; charged polymers. The disadvantages are the lack of covalent bonds between PDMS and surface modifiers, which lead to the loss of modifiers quickly through desorption [77–79].

In order to improve the difficulties encountered in physisorption, chemical modification methods allow for maintaining a long-term stability of the modified surface. These methods include: chemical vapor deposition, surface segregation and self-assembled monolayers, silanization, and polymer brushes via grafting methods [1,62,80–82].

Adding waxes such as paraffin or beeswax to PDMS has been demonstrated to potentially increase the corrosion resistance, hydrophobicity and thermal and optical properties of PDMS, which is useful in applications such as sensors, wearable devices and superhydrophobic coating [83].

Although the methods listed above have been successful in improving the hydrophilicity of the PDMS surface, they have some limitations, such as chemical instability, the need for specific equipment, limited manufacturing process for large scale and some methods cause loss of transparency, loss of mechanical properties and do not provide the hydrophilic surface for a long period of time [62]. Considering these facts, the work of Gökaltun et al. [84] presents a simplified method of easy manufacture, which uses copolymers composed of poly(ethylene glycol) and PDMS segments (PDMS-PEG) to reduce the hydrophobicity of PDMS without changing its transparency, biocompatibility and mechanical properties, with a durability of 20 months.

# 3. PDMS Manufacturing Process

Sylgard® 184 Silicone Elastomer Kit is the most used commercial PDMS. It consists of a monomer and a curing agent, which are usually combined at a weight ratio of 10:1. The compound is mixed and then degassed with a desiccator in order to prevent the formation of micro-bubbles. The PDMS solution is poured over the master mould and then cured in the oven [23]. The curing time depends on the temperature of the oven and on the size of the PDMS sample. The higher the hardening temperature, the less time it will take for the PDMS to cure. After the curing process, the piece is taken out of the mould [57]. Note that, for very specific applications and complex geometries, it is usually advised to perform the curing process at room temperature for at least $4 8 \mathrm { { h } }$ [55,85]. In Table 2 are listed curing times and temperatures recommended by the manufacturer.

Table 2. Recommended curing times and temperatures to produce PDMS samples [57].   

<html><body><table><tr><td>Temperature (C)</td><td>Time</td></tr><tr><td>25</td><td>48h</td></tr><tr><td>100</td><td>35 min</td></tr><tr><td>125</td><td>20 min</td></tr><tr><td>150</td><td>10 min</td></tr></table></body></html>

The monomer and the curing agent can be mixed at a different ratio besides the 10:1 [86] and, as a consequence, some properties change, namely, mechanical [87], optical [88] and gas permeability [89]. Mixing at a higher ratio of cure agent results in a faster hardening time, in a less sticky cured PDMS and in a more fragile PDMS sample. In contrast, mixing with less cure agent results in a longer hardening time, in a stickier cured PDMS and in better mechanical properties. Khanafer et al. [87] found that elastic modulus increases as the mixing ratios increase up to 9:1, after which the elastic modulus starts to decrease as the mixing ratio continues to increase.

# 4. Methods to Characterize PDMS

A wide range of tests are performed to characterize elastomers. Some common tests are scanning electron microscopy, gravimetry, goniometry, nanoindentation, tensile test, X-ray photoelectron spectroscopy and Fourier Transform infrared spectroscopy [21]:

Scanning electron microscopy (SEM) allows thickness measurement and qualitative characterization of PDMS samples [18,42,90–92]; Gravimetry is a method based on gravitational techniques to quantify changes in PDMS sample weight. For example, this method is useful when it is needed to verify if there was or not degradation of the PDMS after chemical immersion [93];   
In order to obtain information on surface hydrophilicity, a goniometry test is performed. Micro water droplets are dropped on the PDMS surface and then the contact angle is measured. This technique allows for verification of if there was or not a change in the wettability of the PDMS after certain treatments [19,39,42,94];   
• Nanoindentation offers the possibility of studying mechanical properties of the outermost layer of PDMS, which is susceptible to destruction due to different treatments, such as UV irradiation [95];   
• Tensile testing allows Young Modulus measurement of PDMS. The Young Modulus can be affected by treatments that may be applied to PDMS, by hardening temperature and time, and by the mixing ratio used to fabricate the PDMS samples [42,96,97];   
• X-ray photoelectron spectroscopy (XPS) is a technique based on the photoelectric effect, which allows identification of the elemental composition of the material. This method is useful when it is needed to verify if any changes in surface composition occurred after the PDMS received any treatment [38,39,98]; Fourier Transform infrared spectroscopy (FTIR) is a method used to obtain the infrared spectrum of absorption or transmission of the PDMS sample. This technique allows examination of the effect of some treatment on the cross-linking of PDMS [38,42,99].

# 5. PDMS Microfabrication

PDMS is patterned through commonly used microfabrication techniques, such as soft-lithography and spin coating. However, especially due to its hydrophobic nature, some of the techniques must be employed alongside with hydrophilic treatments, such as oxygen plasma. Soft-lithography, which is a group of techniques that use patterned elastomers as stamp, mould or mask to generate micropatterns, was developed to allow processing elastomers [100]. However, the fabrication of the most microfluidic devices still relies on photolithography for fabricating SU-8 masters that usually serve as the PDMS mould [20]. Photolithography is a microfabrication technique used to process photoresists, commonly employed in CMOS microelectronics fabrication [101]. The softlithography can be performed in several types, such as microcontact printing $( \mu \mathrm { C P } )$ , replica moulding (REM), micro-transfer moulding $( \mu \mathrm { T M } )$ , micro-moulding in capillaries (MIMIC), solvent-assisted micro-moulding (SAMIM), phase-shift photolithography, cast moulding, embossing and injection. Some of these techniques are briefly described below [100]:

1. Microcontact printing: uses the relief pattern on the surface of a PDMS stamp to form patterns of self-assembled monolayers (SAMs) on the surfaces of substrates by contact;   
2. Replica moulding: replicates the relief pattern on the surface of a PDMS mould by using this structure as a mould for forming structures in a second UV-curable (or thermally curable) prepolymer;   
3. Micro-transfer moulding: a thin layer of liquid prepolymer is applied to the patterned surface of a PDMS mould. It is then placed in contact with the surface of a substrate and the liquid prepolymer is cured to a solid. After peeling off the mould, a patterned micro-structure is left on the surface of the substrate;   
4. Micro-moulding in capillaries: a PDMS mould is placed on the surface of a substrate to form a network of empty channels between them. The channels are filled with a

low viscosity prepolymer, which is then cured to a solid. The mould is removed and a patterned micro-structure is left on the surface of the substrate;

5. Solvent-assisted micro-moulding: a PDMS mould is wetted with a solvent, and it is placed in contact with a substrate (typically an organic polymer). The solvent starts to dissolve the substrate into a fluid or gel that is moulded against the relief structures in the mould. When the fluid solidifies, it forms a pattern relief structure complementary to that in the surface of the mould.

The soft-lithography process begins with the preparation of the elastomeric stamp or the mould by cast moulding. Most of the time, cast moulding implies the use of photolithographic techniques to fabricate the master. PDMS is the most widely used elastomer for this process because of its outstanding properties: low interfacial free energy, it does not swell with humidity, good thermal stability, optical transparency, isotropy and homogeneity [100].

Additionally, spin coating is a common microfabrication method for producing polymer films of controlled and uniform thickness. In this process, a liquid film is spread by centrifugal force onto a rotating substrate. This technique is commonly used for deposition of polymer resist layers in the photolithographic processing of a master mould. It is formulation dependent: increased amounts of cross-linker agent in the formulation decrease film thickness [21,102].

The hydrophobic nature of PDMS brings, in some cases, limitations in the microfabrication processes. There are applications, such as cell culture, immunoassay and biomolecule separation, where the modification of the hydrophobic surface of native PDMS to a hydrophilic surface is indispensable. For example, when endothelial cell seeding is needed, hydrophilic modification of the PDMS surface is indispensable for a successful seeding [103]. However, it is important that the hydrophilic treatment does not affect its transparency, as transparency is a key property that makes PDMS the material of choice for certain applications. Oxygen plasma is the most employed treatment that leads to an increase in PDMS surface hydrophilicity because of its short treatment time, its easy operation and that it does not affect the PDMS transparency [21,65,104,105]. However, this treatment is also known for losing its effects within minutes after exposure to air. For this reason, a variety of well-studied treatments have emerged for this purpose [19,69–73]. Additionally, some articles reported that oxygen plasma may damage PDMS surface [62,106] and, therefore, Shin et al. reported three different treatments that do not require oxygen plasma pre-treatment, including Teflon coating, commercially available water-repellents and perfluorodecyltrichlorosilane (FDTS) [107]. The authors showed that the Teflon and the water-repellent decreased the hydrophobicity of PDMS with great chemical stability and without significantly affecting its transparency. UV/ozone treatments and corona discharge are also commonly employed hydrophilic treatments; however, as with oxygen plasma treatment, PDMS quickly recovers its hydrophobicity [62]. There have been efforts to improve some of these treatments; however, the best way to achieve an effective and long-lasting treatment seems to be the combination of a surface activation with a covalent surface functionalization [19,106]. For example, Zhao et al. [108] proposed a method where PDMS is firstly activated by oxygen plasma treatment and then it is coated with a zwitterionic poly(methacrylate) copolymer (PMGT). This method allowed for decreasing the water contact angle (WCA) of native PDMS from $1 0 8 ^ { \circ }$ to $3 0 ^ { \circ }$ , with a duration of at least $2 0 0 \mathrm { { h } }$ . Further, Zhou et al. [19] suggest a combination of gas-phase with wet chemical methods in order to achieve a better surface stability in a shorter treatment time. Examples of these treatments are the combination of UV or plasma treatment and silanization, the combination of UV or plasma treatment and graft polymerization and the combination of plasma treatment and layer-by-layer (LBL) assembly.

Sterilization is a required procedure for most biomedical applications. In some cases, this process must be done alongside the microfabrication process. There are three mainly used sterilization methods: cleaning with ethanol, ultraviolet light exposure and the steam autoclave procedure. Sterilization does not significantly affect PDMS hydrophobicity. However, steam autoclaving increases the storage modulus and ultimate tensile stress [21,109–114].

# 6. PDMS Applications

# 6.1. PDMS-Based Microchip

Microfluidic devices have been widely studied and developed and, in order to take them to the market, they must be low-cost and capable of mass production. The use of PDMS to fabricate these devices makes it possible to achieve those goals. Nowadays, there are a variety of PDMS-based microchips that have been developed, most of them alongside glass [115–121]. The combination of PDMS and glass has been employed with great results. In Figure 1 is presented a schematic illustration of the fabrication of a glass/PDMS microchip. For example, Schöning et al. [116] developed a PDMS/glass separation microchip, based on typical semiconductor-compatible production methods, and which provides a simplification of the electrophoresis-based biosensor set-up.

![](images/525e59ffd6ae93bfddb17a6651089636e4263cb14d6fb5552b42b908823b673a.jpg)  
Figure 1. Schematic illustration of the fabrication for glass/PDMS microchip: (a) PDMS layeFigure 1. Schematic illustration of the fabrication for glass/PDMS microchip: (a) PDMS layer cated by replica moulding; (b) part of SPE channel in PDMS layer was cut off; (c) PDMS layfabricated by replica moulding; (b) part of SPE channel in PDMS layer was cut off; (c) PDMS layer sealed with the thin glass cover slip; (d) MISPE monolithic capillary column was couplewas sealed with the thin glass cover slip; (d) MISPE monolithic capillary column was coupled with glass/PDMS chip to form the final chip. A, B, C, D: holes, E: sample reservoir, F: buffer reservglass/PDMS chip to form the final chip. A, B, C, D: holes, E: sample reservoir, F: buffer reservoir, sample waste reservoir, H: buffer waste reservoir, I: separation channel, J: SPE channel, K: G: sample waste reservoir, H: buffer waste reservoir, I: separation channel, J: SPE channel, K: MISPE monolithic capillary column and L: epoxy glue. Reprinted with permission from reference [115]. Copyright 2020 Elsevier.

2. PDMS Biomodels for Hemodynamic StudiesTemperature gradient generation is a commonly used process in microfluidics. As mentioned above, PDMS can be very useful in the fabrication of microchipHa et al. [122] presented a PDMS microchip that allows temperature gradient generation allow analysing samples. Reports on the use of this material for the replication of cusing sound waves as a heating mechanism. The use of PDMS allowed the fabrication of a vascular flow are also found in the literature. This type of atransparent, dynamic, inexpensive and easy-to-fabricate system.

The hydrophobic nature of PDMS usually brings issues to the microchips. Qiang Niu et al. [120] developed a PDMS/glass microchip for PCR; however, the team came across the formation of bubbles on the PDMS surface during the sample loading. To overcome this, they implemented an irreversible bonding and sealing between the glass and PDMS. Additionally, protein adsorption occurred on the chip surface, which was eurysm walls [49]. To understand these mechanical effects, studies were conducted overcome by treating the surface with BSA (Bovine Serum Albumin). Table 3 presents a list an intercranial aneurysm model was developed using PDMS to simulate the mechof PDMS-based microchips, as well as the motivations that led the authors to use PDMS in behaviour their devices.

Table 3. Applications of PDMS-based microchips and respective motivations for using PDMS.   

<html><body><table><tr><td>Application</td><td>PDMS Preparation</td><td>Motivations for Using PDMS</td><td>Reference</td></tr><tr><td>On-ine spledctivityetand</td><td>Mixing ratio-10:1,w/w Oxygen plasma treatment for 1-2 min</td><td></td><td>[115]</td></tr><tr><td>Genetic analysis by functional integpilaai electrophoresis (CGE)</td><td>Mixing ratio—10:1,w /w Degassing time-15 min Curing temperature-65C Post-curiie135C Post-curing time-15 min Hydrophilic treatment with HCl solution at 25C for 4h</td><td>Low-cost, suitability for microscale moulding, high reproducibility on a micrembilityae highas conductivity and transparency.</td><td>[118]</td></tr><tr><td>Polymerase chain reaction (PCR)</td><td>Mixing ratio-10:1,w/w Curing temperature-95C Curing time-30 min</td><td>Low thermal conductivity, simple fabrication,low-cost,disposability, biocompatibility, irreversible bonding with glass and transparency.</td><td>[120]</td></tr><tr><td>Electrophoresis device for continuous on-line in vivo monitoring of micro dialysis samples</td><td>Mixing ratio-10.5:1.5,w/w 5 mm-thick layer curing temperature—90 C 1m 1 mm-thiclartie1518min Post-curing time-overnight</td><td>Easy manufacture, good reproductivity and transparency.</td><td>[121]</td></tr><tr><td>Generation of temperature gradient</td><td>Mixing ratio-10:1,w /w</td><td>Low-anutrturearency easy thermal conductivity</td><td>[122]</td></tr></table></body></html>

# 6.2. PDMS Biomodels for Hemodynamic Studies

As mentioned above, PDMS can be very useful in the fabrication of microchips that allow analysing samples. Reports on the use of this material for the replication of cardiovascular flow are also found in the literature. This type of application allows a better understanding and study of cardiovascular diseases, such as aneurysms.

An aneurysm is characterized by artery wall weakness, which can lead to artery rupture and, consequently, to death. Hemodynamic studies have been done to understand aneurysms; however, they cannot explain the mechanical effects on the expansion of the aneurysm walls [49]. To understand these mechanical effects, studies were conducted where an intercranial aneurysm model was developed using PDMS to simulate the mechanical behaviour of blood vessels [49,123]. PDMS is a well-suited material for this purpose due to its hyperelastic behaviour, which is very similar to that of blood vessels, and the ability to make circular microchannels. Another advantage of using PDMS is that it is transparent, which facilitates monitoring of the blood flow. Additionally, recent studies show that is possible to seed a culture of endothelial cells on the microchannels’ walls, which allows the creation of a very similar environment to that found in microcirculation [90,124,125]. Lima et al. [126] proposed a microfluidic device containing rectangular microchannels in PDMS, where in vitro blood flow measurements were conducted by means of a confocal micro-PIV system. The authors demonstrated that, by using soft-lithography, it is possible to produce precise and reproductible rectangular microchannels and to perform detailed blood flow studies. The same authors have performed a similar study, this time by using circular PDMS microchannels [127]. Although there are already several studies using circular microchannels [127–130], the majority of the PDMS microchannels used to study in vitro blood flow phenomena have rectangular cross sections. Hence, by using rectangular PDMS microchannels, several research works have been performed on different kinds of constrictions to study the deformability behaviour of blood cells [131–136] and air bubbles [137,138]. Cell deformability is a biomarker which can be used to distinguish between healthy and diseased cells. Microfluidic models have been developed in order to better understand and, consequently, diagnose diseases such as malaria [139,140], cancer [141,142] and end-stage[143]. Most studies aim to better understand red blood cells (RBC); however, Rokidney disease [143]. Most studies aim to better understand red blood cells (RBC); however, et al. [144] developed a novel integrative microfluidic device which is capable of Rodrigues et al. [144] developed a novel integrative microfluidic device which is capableg the deformation index of both white blood cells (WBC) and RBC. The same author of assessing the deformation index of both white blood cells (WBC) and RBC. The samesented a microfluidic tool to study the hemocompatibility of nanoparticles syntheauthor also presented a microfluidic tool to study the hemocompatibility of nanoparticlesr theragnostic applications [145]. Additionally, by using microchannels having bisynthesized for theragnostic applications [145]. Additionally, by using microchannels hav-ns and confluences, several studies have been carried out to better understand the ing bifurcations and confluences, several studies have been carried out to better understande of these complex geometries on blood flow behaviour [146–152]. the influence of these complex geometries on blood flow behaviour [146–152].ctangular microchannels are the most common geometry obtained by soft-l

Rectangular microchannels are the most common geometry obtained by soft-lithography.ever, this kind of geometry can lead to some erratic measurements because However, this kind of geometry can lead to some erratic measurements because the shear stress imposed on the cell is different and, consequently, the pressure build-up in the channel is not the same as if it were built-up in a circular section [124]. Hence, studies have been conducted to establish methods that allow the construction of circular microchannels of PDMS. For example, Fiddes et al. [124] proposed a method which begins by fabricating rectangular microchannels using soft-lithography techniques, followed by the introduc-icating rectangular microchannels using soft-lithography techniques, followed by tion of a stream gas and a solution of the silicone oligomer in an organic solvent. Then,oduction of a stream gas and a solution of the silicone oligomer in an organic solthrough the polymerization of the oligomer and the removal of the solvent, the authorshen, through the polymerization of the oligomer and the removal of the solvent, demonstrated the ability to control the shape and the diameter of the microchannel’s cross-hors demonstrated the ability to control the shape and the diameter of the microsection. Additionally, Choi et al. [90] showed that, combining soft-lithography techniquesl’s cross-section. Additionally, Choi et al. [90] showed that, combining soft-lithogwith the reflow phenomenon of a positive photoresist, it is possible to generate circularechniques with the reflow phenomenon of a positive photoresist, it is possible to PDMS microfluidic channels. In Figure 2 are presented some examples of biomodels fore circular PDMS microfluidic channels. In Figure 2 are presented some examples hemodynamic studies.odels for hemodynami

![](images/cb44f5496211ebe115750a86a79cc5ef52e792ca0e4cea8b401d1d10c5a34ba9.jpg)  
. Example of PDMS biomodels for hemodynamic studies: (a) rectangular PDMS microchan-Figure 2. Example of PDMS biomodels for hemodynamic studies: (a) rectangular PDMS microchannel dy in vitro blood and ensemble velocity profiles (U) obtained in the middle plane by means to study in vitro blood and ensemble velocity profiles (U) obtained in the middle plane by means of a ocal micro-PIV system (adapted from [126]); (b) schematic diagram of the blood collection confocal micro-PIV system (adapted from [126]); (b) schematic diagram of the blood collection and s deformability tests in PDMS microfluidic device (from [143]); (c) circular PDMS micro-cells deformability tests in PDMS microfluidic device (from [143]); (c) circular PDMS microchannels to study in vitro blood behavior (adapted from [152]).

It is important to notice that, despite the ability to mimic the cardiovascular vessels behaviour through PDMS microchannels, there would always be missing points. For that reason, it is of great importance to combine the PDMS micro devices with well-suited measurement techniques. Rodrigues et al. [123] proposed the use of the Digital Image Correlation (DIC) method, which proved to be suitable to study small displacements happening in in vitro models. A summary of the advantages and limitations of some of the methods used to fabricate microchannels is presented in Table 4.

Table 4. Advantages and limitations of techniques used to fabricate microchannels.   

<html><body><table><tr><td>Geometry</td><td>Method</td><td>Advantages</td><td>Limitations</td><td>Application</td><td>Reference</td></tr><tr><td>Rectangular</td><td>Soft lithography</td><td>Generation of precise, reproducible and ersatile experimeniae controltersad acurateivesimpmend</td><td>Difrentgmeometry trom Difficulties in achieving stable cellseding athecorher of</td><td>IntegrtiPrio wonfacal PDMS microchannel to velbtin blods</td><td>[126]</td></tr><tr><td rowspan="4">Circular</td><td>Wire casting technique</td><td>Simple and specialized equipment.</td><td></td><td> hemodyn amic studies</td><td>[127]</td></tr><tr><td>expansion molding</td><td>Inexpen sivead fabPoasig mutple</td><td>Itcan be hardto abaiatea</td><td>Evaluate the clotting and anticeagualant</td><td>[128]</td></tr><tr><td>Combinatiowif tht refow posesa</td><td></td><td>Bona generate perfect</td><td>T</td><td></td></tr><tr><td>rectangular Reshaping</td><td>Ability of controlling the</td><td>challenging.</td><td>diagnostics</td><td></td></tr><tr><td></td><td>oligomer around a gas steam</td><td>constrictions.</td><td>Relatively complex and Dificutyisiventrhling he exact diameter of the channel.</td><td>Mimicin viw sustems</td><td>[124]</td></tr></table></body></html>

# 6.3. PDMS-Based Blood Analogues

Blood analogues are fluids commonly used to perform hemodynamic experiments due mainly to safety problems related to the use of real blood in these experiments. Initially, blood analogues were simple fluids composed by mixtures of glycerol and water or by xanthan gum diluted in glycerine and/or water [153,154]. However, by using these kinds of blood analogues, it is not possible to study different kinds of flow phenomena that happen at the micro scale level, such as the cell-free layer, plasma skimming and cell margination [101,155,156]. These microcirculation phenomena do not happen by using blood analogue fluids without solid elements, such as microparticles and microcapsules. Hence, during the past years, several works have been developing different kinds of particulate blood analogue fluids containing microparticles with varying stiffness, shape and size for biomedical applications [157–166].

Due to its unique mechanical properties, PDMS has also been used to produce flexible microparticles to be used in blood analogue fluids. Recently, Muñoz-Sánchez et al. [167] proposed a flow-focusing technique to produce flexible PDMS microparticles for biomedical applications (Figure 3). The PDMS microparticles were produced by using different kindsa ratio of 6:4 have demonstrated the ability to reproduce the steady shear visc of ratios (base/curing agent), and rheological measurements performed with a ratio ofof ovine RBCs suspended in Dextran 40 [167–169]. Although it is possible to p 6:4 have demonstrated the ability to reproduce the steady shear viscosity curve of ovine RBCs suspended in Dextran 40 [167–169]. Although it is possible to produce flexible PDMS microparticles with a high degree of monodispersity by using the flow-focusing technique,ing technique, the production rate is relatively low. In order to overcome thi the production rate is relatively low. In order to overcome this limitation, Choi et al. [170]Choi et al. [170] and Lopez et al. [171] have proposed a simple emulsification t and Lopez et al. [171] have proposed a simple emulsification technique to obtain a massobtain a mass production of PDMS microparticles. More recently, Carneiro production of PDMS microparticles. More recently, Carneiro et al. [172] have developedhave developed another method, based on a multi-stage membrane emulsif another method, based on a multi-stage membrane emulsification process, to obtain high throughput production of PDMS microparticles. The development of blood analogue fluids with PDMS microparticles that mimic the behaviour of RBCs is still at an early stage of development. The most critical challenges that need to be solved are the mass productionat an early stage of development. The most critical challenges that need to be of monodisperse PDMS microparticles, stiffness, aggregation and fast agglomeration ofthe mass production of monodisperse PDMS microparticles, stiffness, aggre the PDMS particles within microchannels with complex geometries, such as constrictionsfast agglomeration of the PDMS particles within microchannels with complex and bifurcations.such as constri

![](images/0bb1ea9d81358b3474541f26c6e8bd7574f7bacf6a5a33c39f153fe86b46d2c8.jpg)  
Figure 3. Flexible PDMS microparticles to be used in blood analogue fluids for biomeFigure 3. Flexible PDMS microparticles to be used in blood analogue fluids for biomedical applications, produced by (a) a two-syringe membrane emulsification technique (adapted frotions, produced by (a) a two-syringe membrane emulsification technique (adapted from [171]); (b) a a flow-focusing technique (adapted froflow-focusing technique (adapted from [173]).

# 6.4. PDMS-Based Coatings for Medical Implants

PDMS has been widely studied to integrate medical implants, especially due to PDMS has been widely studied to integrate medical implants, especiallits biocompatibility. Such implants are usually fabricated with biomedical grade metals biocompatibility. Such implants are usually fabricated with biomedical grade (e.g., tantalum, zirconium, niobium), as well as titanium and its alloys [174]. However, these tantalum, zirconium, niobium), as well as titanium and its alloys [174]. Howpresent some limitations concerning blood compatibility, bone conductivity and bioactivity [38]. When developing an implant, some important aspects should be taken in consideration: biocompatibility, osseointegration, corrosion resistance and micro-invasiveness. Osseointegration is related to the effective linkage between the metal and the bone. A weak bonding can lead to the formation of biofilms on implants, which can cause infections. Recent studies have demonstrated that the surface modification of implants, in order to achieve nano-/microscale features, brings great advantages concerning osseointegration [39].

The creation of microscale features on ceramics or polymers is simpler than on metal. Considering the fact that PDMS allows the fabrication of hydrophobic and smooth surfaces has led to their use for developing coatings that help in the osseointegration of implants [38–42]. Rossi de Aguiar et al. [38] studied a sol-gel coating based on PDMS for metallic surfaces such as titanium and stainless steel. The authors demonstrated that the hydrophobic nature of PDMS allows the formation of an anti-biofouling surface, preventing the bacterial adhesion. Additionally, Tran et al. [39] developed a coating that involved the hydrolysis and co-condensation of PDMS and tantalum (Ta) ethoxide to produce tantalum oxide. This PDMS hybrid material has biocompatibility and corrosion resistance properties, which allowed a great osseointegration. The integration of nanoparticles, such as $\mathrm { C u O } ,$ has been proven to improve the antibacterial characteristic of PDMS-based coatings, as demonstrated by Tavakoli et al. [42]. Table 5 comprises a list of some PDMS-based coatings that have been developed in the past years.

Table 5. Developments and applications of PDMS-based coatings.   

<html><body><table><tr><td>Application</td><td>PDMS Preparation</td><td>Motivation for Using PDMS</td><td>Reference</td></tr><tr><td>Urethanes PDMS-based hybrid coating for metallic dental implants</td><td>Curing temperature-60 C Curing time-24 h</td><td>sureateendt capablefraderindtsellsch</td><td>[38]</td></tr><tr><td>Tantalumorxide-PDMpybrid</td><td>M Curing time-15 min</td><td>micrometer-thick coatings.</td><td>[39]</td></tr><tr><td>Bioactive CaO-SiO2-PDMS coatings</td><td>Sol-gel dip-coating method. Thepc Curing temperature-150C Curing time-24h</td><td>Mechanical popPDmisand</td><td>[40]</td></tr><tr><td>PDMSumedcotiforaader</td><td>Miigeo10:2 (/t) Curing time-2 h</td><td>B Young&#x27;s modulus</td><td>[41]</td></tr><tr><td>CuO-PDMS-SiO2 coatings</td><td>Mixing ratio-10:1 (w /w) Curinrigpere-150C</td><td>Iepoedbii</td><td>[42]</td></tr></table></body></html>

# 7. Conclusions and Further Perspectives

Microchips for biomedical applications are devices that allow monitoring and analysis of samples. The use of PDMS in these devices offers great advantages such as optical transparency, being easy-to-manufacture and having a low-cost, which are important requirements when fabricating microchips. Additionally, the permeability to gases is a unique advantage to culture living cells in closed microchannels, a task that is extremely complex to achieve in glass microchannels. However, the hydrophobic nature of PDMS brings some limitations during the fabrication and flow transport phenomena, especially for biological applications. Developments of treatments that contradict the hydrophobic property have been made and these limitations are easily overcome by applying simple and fast hydrophilic treatments to PDMS. The lack of industrial processes to manufacture PDMS is still an issue. There are already methods that allow good replications of microfabricated PDMS; however, they are far from an industrial scale.

Replication of the cardiovascular system using PDMS microchannels is on a good path to be an application well-suited for the study of cardiovascular diseases. The hyper-elastic behaviour and transparency are great advantages that make PDMS the chosen material in these types of applications. Herein, the hydrophobic nature of PDMS can be a limitation as well, in the blood flow itself but also when it is intended to grow endothelial cell cultures on its walls.

Additionally, PDMS plays an important role in medical implant applications, especially due to its biocompatibility and hydrophobic nature. These characteristics allow the production of antibacterial coatings for implants, which is a requirement when developing implants. PDMS also allows the production of smooth surfaces through processes of microfabrication that help in the osseointegration of the implant in the body. Although PDMS coatings are already available on the market, there are more developments that can be made to increase their features and durability.

It is interesting to note that the hydrophobic nature of PDMS can be a limitation in some applications, such as microchips and microchannel fabrication, but a great advantage in others, such as in implant coatings, solar panels and face masks.

In summary, PDMS opens a wide range of possibilities to make great developments in biomedical applications. With regards to further work, it is important to continue studying more methods to produce PDMS-based devices on a larger scale which would further enable these devices to reach the market. Additionally, the currently available PDMS hydrophilic treatments need further developments and improvements as, most of the time, they do not last long. Hence, it is important to develop new methods or improve the existing ones in order to achieve a higher permanent hydrophilic feature for PDMS.

Author Contributions: Conceptualization, I.M., A.S. and P.S.; writing—original draft preparation, I.M., A.S., P.S. and J.R.; writing—review and editing, G.M., E.M.S.C., J.R. and R.L.; supervision, G.M. and R.L.; funding acquisition, G.M., J.R. and R.L. All authors have read and agreed to the published version of the manuscript.

Funding: This work was supported by projects NORTE-01-0145-FEDER-029394 and NORTE-01- 0145-FEDER-030171, through Programa Operacional Regional do Norte–Norte Portugal Regional Operational Programme (NORTE 2020), under the PORTUGAL 2020 Partnership Agreement through the European Regional Development Fund (FEDER) and by Fundação para a Ciência e Tecnologia (FCT), IP, project reference PTDC/EMD-EMD/29394/2017 and PTDC/EME-SIS/30171/2017.

Institutional Review Board Statement: Not applicable.

Informed Consent Statement: Not applicable.

Data Availability Statement: Not applicable.

Acknowledgments: The authors also acknowledge the strategic grants by the projects UIDB/04436/2020, UIDP/04436/2020, UIDB/00690/2020, UIDB/04650/2020 and UIDB/04077/2020 from FCT.

Conflicts of Interest: The authors declare no conflict of interest.

# References

1. Poll, M.; Zhou, F.; Ramstedt, M.; Hu, L.; Huck, W. A Self-assembly approach to chemical micropatterning of Poly(dimethylsiloxane). Angew. Chem. Int. Ed. 2007, 46, 6634–6637. [CrossRef] [PubMed]   
2. Berthier, E.; Young, E.W.K.; Beebe, D. Engineers are from PDMS-land, Biologists are from Polystyrenia. Lab Chip 2012, 12, 1224–1237. [CrossRef]   
3. Merkel, T.C.; Bondar, V.I.; Nagai, K.; Freeman, B.D.; Pinnau, I. Gas sorption, diffusion, and permeation in Poly(dimethylsiloxane). J. Polym. Sci. Part B Polym. Phys. 2000, 38, 415–434. [CrossRef]   
4. Kuddannaya, S.; Bao, J.; Zhang, Y. Enhanced In Vitro biocompatibility of chemically modified Poly(dimethylsiloxane) surfaces for stable adhesion and long-term investigation of brain cerebral cortex cells. ACS Appl. Mater. Interfaces 2015, 7, 25529–25538. [CrossRef]   
5. Lee, S.; Shin, H.-J.; Yoon, S.-M.; Yi, D.K.; Choi, J.-Y.; Paik, U. Refractive index engineering of transparent $Z \mathrm { r O } _ { 2 }$ –polydimethylsiloxane nanocomposites. J. Mater. Chem. 2008, 18, 1751–1755. [CrossRef]   
6. Johnston, I.D.; Tracey, M.C.; Davis, J.B.; Tan, C.K.L. Micro throttle pump employing displacement amplification in an elastomeric substrate. J. Micromech. Microeng. 2005, 15, 1831–1839. [CrossRef]   
7. Dardouri, M.; Bettencourt, A.; Martin, V.; Carvalho, F.A.; Santos, C.; Monge, N.; Santos, N.C.; Fernandes, M.H.; Gomes, P.S.; Ribeiro, I.A.C. Using plasma-mediated covalent functionalization of rhamnolipids on polydimethylsiloxane towards the antimicrobial improvement of catheter surfaces. Mater. Sci. Eng. C 2021, 112563. [CrossRef]   
8. Kumar, R.; Sahani, A. Role of superhydrophobic coatings in biomedical applications. Mater. Today 2021, 45, 5655–5659. [CrossRef]   
9. Wu, X.; Kim, S.-H.; Ji, C.-H.; Allen, M. A solid hydraulically amplified piezoelectric microvalve. J. Micromech. Microeng. 2011, 21, 95003–95011. [CrossRef]   
10. Bozukova, D.; Pagnoulle, C.; Jérôme, R.; Jérôme, C. Polymers in modern ophthalmic implants—Historical background and recent advances. Mater. Sci. Eng. R Rep. 2010, 69, 63–83. [CrossRef]   
11. Yu, H.; Zhou, G.; Sinha, S.K.; Chau, F.S.; Wang, S. Lens integrated with self-aligned variable aperture using pneumatic actuation method. Sens. Actuators A Phys. 2010, 159, 105–110. [CrossRef]   
12. Doutel, E.; Viriato, N.; Carneiro, J.; Campos, J.B.L.M.; Miranda, J.M. Geometrical effects in the hemodynamics of stenotic and non-stenotic left coronary arteries-numerical and in vitro approaches. Int. J. Numer. Methods Biomed. Eng. 2019, 35, e3207. [CrossRef] [PubMed]   
13. Usmani, A.; Muralidhar, K. Flow in an intracranial aneurysm model: Effect of parent artery orientation. J. Vis. 2018, 21, 795–818. [CrossRef]   
14. Kim, S.-J.; Lee, D.-S.; Kim, I.-G.; Sohn, D.-W.; Park, J.-Y.; Choi, B.-K.; Kim, S.-W. Evaluation of the biocompatibility of a coating material for an implantable bladder volume sensor. Kaohsiung J. Med. Sci. 2012, 28, 123–129. [CrossRef]   
15. Carta, R.; Jourand, P.; Hermans, B.; Thoné, J.; Brosteaux, D.; Vervust, T.; Bossuyt, F.; Axisa, F.; Vanfleteren, J.; Puers, R. Design and implementation of advanced systems in a flexible-stretchable technology for biomedical applications. Sens. Actuators A Phys. 2009, 156, 79–87. [CrossRef]   
16. Fujii, T. PDMS-based microfluidic devices for biomedical applications. Microelectron. Eng. 2002, 61–62, 907–914. [CrossRef]   
17. Raj, M.K.; Chakraborty, S. PDMS microfluidics: A mini review. J. Appl. Polym. Sci. 2020, 137, 48958. [CrossRef]   
18. Chen, W.; Lam, R.H.W.; Fu, J. Photolithographic surface micromachining of polydimethylsiloxane (PDMS). Lab Chip 2012, 12, 391–395. [CrossRef]   
19. Zhou, J.; Ellis, A.V.; Voelcker, N.H. Recent developments in PDMS surface modification for microfluidic devices. Electrophoresis 2010, 31, 2–16. [CrossRef]   
20. Weibel, D.B.; DiLuzio, W.R.; Whitesides, G.M. Microfabrication meets microbiology. Nat. Rev. Microbiol. 2007, 5, 209–218. [CrossRef]   
21. Mata, A.; Fleischman, A.J.; Roy, S. Characterization of Polydimethylsiloxane (PDMS) Properties for Biomedical Micro/Nanosystems. Biomed. Microdevices 2005, 7, 281–293. [CrossRef]   
22. Ashraf, M.W.; Tayyaba, S.; Afzulpurkar, N. Micro Electromechanical Systems (MEMS) based microfluidic devices for biomedical applications. Int. J. Mol. Sci. 2011, 12, 3648–3704. [CrossRef]   
23. Schneider, F.; Fellner, T.; Wilde, J.; Wallrabe, U. Mechanical properties of silicones for MEMS. J. Micromech. Microeng. 2008, 18, 065008. [CrossRef]   
24. Bubendorfer, A.; Liu, X.; Ellis, A.V. Microfabrication of PDMS microchannels using SU-8/PMMA moldings and their sealing to polystyrene substrates. Smart Mater. Struct. 2007, 16, 367–371. [CrossRef]   
25. Pinto, V.C.; Sousa, P.J.; Cardoso, V.F.; Minas, G. Optimized SU-8 Processing for low-cost microstructures fabrication without cleanroom facilities. Micromachines 2014, 5, 738–755. [CrossRef]   
26. Shakeri, A.; Khan, S.; Didar, T.F. Conventional and emerging strategies for the fabrication and functionalization of PDMS-based microfluidic devices. Lab Chip 2021, 21, 3053–3075. [CrossRef]   
27. Jo, M.C.; Guldiken, R. Effects of polydimethylsiloxane (PDMS) microchannels on surface acoustic wave-based microfluidic devices. Microelectron. Eng. 2014, 113, 98–104. [CrossRef]   
28. Levitt, M.R.; Mandrycky, C.; Abel, A.; Kelly, C.M.; Levy, S.; Chivukula, V.K.; Zheng, Y.; Aliseda, A.; Kim, L.J. Genetic correlates of wall shear stress in a patient-specific 3D-printed cerebral aneurysm model. J. Neurointerv. Surg. 2019, 11, 999–1003. [CrossRef] [PubMed]   
29. Doutel, E.; Carneiro, J.; Oliveira, M.; Campos, J.B.L.M.; Miranda, J. Fabrication of 3d mili-scale channels for hemodynamic studies. J. Mech. Med. Biol. 2014, 5, 21. [CrossRef]   
30. Doutel, E.; Carneiro, J.; Campos, J.B.L.M.; Miranda, J.M. Experimental and numerical methodology to analyze flows in a coronary bifurcation. Eur. J. Mech. B Fluids 2018, 67, 341–356. [CrossRef]   
31. Geoghegan, P.H.; Buchmann, N.A.; Spence, C.J.T.; Moore, S.; Jermy, M. Fabrication of rigid and flexible refractive-index-matched flow phantoms for flow visualisation and optical flow measurements. Exp. Fluids 2012, 52, 1331–1347. [CrossRef]   
32. Ford, M.D.; Nikolov, H.N.; Milner, J.S.; Lownie, S.P.; Demont, E.M.; Kalata, W.; Loth, F.; Holdsworth, D.W.; Steinman, D.A. PIV-measured versus CFD-predicted flow dynamics in anatomically realistic cerebral aneurysm models. J. Biomech. Eng. 2008, 130, 21015. [CrossRef]   
33. Brindise, M.C.; Rothenberger, S.; Dickerhoff, B.; Schnell, S.; Markl, M.; Saloner, D.; Rayz, V.L.; Vlachos, P.P. Multi-modality cerebral aneurysm haemodynamic analysis: In vivo 4D flow MRI, in vitro volumetric particle velocimetry and in silico computational fluid dynamics. J. R. Soc. Interface 2019, 16, 20190465. [CrossRef] [PubMed]   
34. Amili, O.; Golzarian, J.; Coletti, F. In Vitro Study of particle transport in successively bifurcating vessels. Ann. Biomed. Eng. 2019, 47, 2271–2283. [CrossRef]   
35. Li, Y.; Verrelli, D.I.; Yang, W.; Qian, Y.; Chong, W. A pilot validation of CFD model results against PIV observations of haemodynamics in intracranial aneurysms treated with flow-diverting stents. J. Biomech. 2020, 100, 109590. [CrossRef] [PubMed]   
36. Chivukula, V.K.; Levitt, M.R.; Clark, A.; Barbour, M.C.; Sansom, K.; Johnson, L.; Kelly, C.M.; Geindreau, C.; Rolland du Roscoat, S.; Kim, L.J.; et al. Reconstructing patient-specific cerebral aneurysm vasculature for in vitro investigations and treatment efficacy assessments. J. Clin. Neurosci. Off. J. Neurosurg. Soc. Australas. 2019, 61, 153–159. [CrossRef]   
37. Paliwal, N.; Damiano, R.J.; Varble, N.A.; Tutino, V.M.; Dou, Z.; Siddiqui, A.H.; Meng, H. Methodology for Computational Fluid Dynamic Validation for Medical Use: Application to Intracranial Aneurysm. J. Biomech. Eng. 2017, 139, 1210041–12100410. [CrossRef]   
38. Rossi de Aguiar, K.M.F.; Nascimento, M.V.; Faccioni, J.L.; Noeske, P.L.M.; Gätjen, L.; Rischka, K.; Rodrigues-Filho, U.P. Urethanes PDMS-based: Functional hybrid coatings for metallic dental implants. Appl. Surf. Sci. 2019, 484, 1128–1140. [CrossRef]   
39. Tran, P.A.; Fox, K.; Tran, N. Novel hierarchical tantalum oxide-PDMS hybrid coating for medical implants: One pot synthesis, characterization and modulation of fibroblast proliferation. J. Colloid Interface Sci. 2017, 485, 106–115. [CrossRef] [PubMed]   
40. Hijón, N.; Manzano, M.; Salinas, A.; Vallet-Regí, M. Bioactive ${ \mathrm { C a O } } { \cdot } { \mathrm { S i O } } _ { 2 }$ -PDMS coatings on Ti6Al4V substrates. Chem. Mater. 2005, 17, 1591–1596. [CrossRef]   
41. Lee, D.S.; Kim, S.J.; Sohn, J.H.; Kim, I.G.; Kim, S.W.; Sohn, D.W.; Kim, J.H.; Choi, B. Biocompatibility of a pdms-coated micro-device: Bladder volume monitoring sensor. Chin. J. Polym. Sci. 2012, 30, 242–249. [CrossRef]   
42. Tavakoli, S.; Nemati, S.; Kharaziha, M.; Akbari-Alavijeh, S. Embedding CuO nanoparticles in PDMS- $S \mathrm { i } O _ { 2 }$ coating to improve antibacterial characteristic and corrosion resistance. Colloids Interface Sci. Commun. 2019, 28, 20–28. [CrossRef]   
43. Chen, S.; Jones, J.A.; Xu, Y.; Low, H.-Y.; Anderson, J.M.; Leong, K.W. Characterization of topographical effects on macrophage behavior in a foreign body response model. Biomaterials 2010, 31, 3479–3491. [CrossRef]   
44. Guo, R.; Liu, J. Implantable liquid metal-based flexible neural microelectrode array and its application in recovering animal locomotion functions. J. Micromech. Microeng. 2017, 27, 104002. [CrossRef]   
45. Hassler, C.; Boretius, T.; Stieglitz, T. Polymers for neural implants. J. Polym. Sci. Part B Polym. Phys. 2011, 49, 18–33. [CrossRef]   
46. Wolf, M.P.; Salieb-Beugelaar, G.B.; Hunziker, P. PDMS with designer functionalities—Properties, modifications strategies, and applications. Prog. Polym. Sci. 2018, 83, 97–134. [CrossRef]   
47. Zhao, J.; Sheadel, D.A.; Xue, W. Surface treatment of polymers for the fabrication of all-polymer MEMS devices. Sens. Actuators A Phys. 2012, 187, 43–49. [CrossRef]   
48. Johnston, I.D.; McCluskey, D.K.; Tan, C.K.L.; Tracey, M.C. Mechanical characterization of bulk Sylgard 184 for microfluidics and microengineering. J. Micromech. Microeng. 2014, 24, 035017. [CrossRef]   
49. Victor, A.; Ribeiro, J.; Araújo, F.F. Study of PDMS characterization and its applications in biomedicine: A review. J. Mech. Eng. Biomech. 2019, 4, 1–9. [CrossRef]   
50. Cardoso, C.; Fernandes, C.S.; Lima, R.; Ribeiro, J. Biomechanical analysis of PDMS channels using different hyperelastic numerical constitutive models. Mech. Res. Commun. 2018, 90, 26–33. [CrossRef]   
51. Pan, C.T.; Chen, Y.C.; Lin, P.-H.; Hsieh, C.C.; Hsu, F.T.; Lin, P.-H.; Chang, C.M.; Hsu, J.H.; Huang, J.C. Lens of controllable optical field with thin film metallic glasses for UV-LEDs. Opt. Express 2014, 22, 14411. [CrossRef]   
52. Wang, B.; Liu, H.; Zhang, B.; Han, Y.; Shen, C.; Lin, Q.; Chen, H. Development of antibacterial and high light transmittance bulk materials: Incorporation and sustained release of hydrophobic or hydrophilic antibiotics. Colloids Surf. B Biointerfaces 2016, 141, 483–490. [CrossRef] [PubMed]   
53. Pan, C.T.; Chen, Y.C.; Chen, Y.J.; Wang, W.C.; Yang, H.C.; Wu, H.C. Compound optical film using gray scale mask embedded with microvoids. Adv. Condens. Matter Phys. 2012, 2012, 942018. [CrossRef]   
54. Riehle, N.; Thude, S.; Götz, T.; Kandelbauer, A.; Thanos, S.; Tovar, G.; Lorenz, G. Influence of PDMS molecular weight on transparency and mechanical properties of soft polysiloxane-urea-elastomers for intraocular lens application. Eur. Polym. J. 2018, 101, 190–201. [CrossRef]   
55. Sales, F.; Souza, A.; Ariati, R.; Noronha, V.; Giovanetti, E.; Lima, R.; Ribeiro, J. Composite material of PDMS with interchangeable transmittance: Study of optical, mechanical properties and wettability. J. Compos. Sci. 2021, 5, 110. [CrossRef]   
56. Mark, J.E. (Ed.) Polymer Data Handbook; Oxford University Press: Oxford, UK, 1999.   
57. The Dow CompanyChemical. SYLGARDTM 184 Silicone Elastomer Technical Datasheet. Silicone Elastomer Technical Data Sheet 2017. Available online: https://consumer.dow.com/en-us/document-viewer.html?ramdomVa $\scriptstyle \cdot =$ 3835418757322904567& docPath $\lfloor =$ /documents/en-us/productdatasheet/11/11-31/11-3184-sylgard-184-elastomer.pdf (accessed on 20 August 2021).   
58. Hong, J.; Lee, J.; Hong, C.; Shim, S. Effect of dispersion state of carbon nanotube on the thermal conductivity of poly(dimethyl siloxane) composites. Curr. Appl. Phys. 2010, 10, 359–363. [CrossRef]   
59. Armani, D.; Liu, C.; Aluru, N. Re-Configurable Fluid Circuits by PDMS Elastomer Micromachining. In Proceedings of the Technical Digest IEEE International MEMS 99 Conference. Twelfth IEEE International Conference on Micro Electro Mechanical Systems (Cat. No.99CH36291), Orlando, FL, USA, 21 January 1999; pp. 222–227.   
60. Müller, A.; Wapler, M.C.; Wallrabe, U. A quick and accurate method to determine the Poisson’s ratio and the coefficient of thermal expansion of PDMS. Soft Matter 2019, 15, 779–784. [CrossRef] [PubMed]   
61. Zhang, G.; Sun, Y.; Qian, B.; Gao, H.; Zuo, D. Experimental study on mechanical performance of polydimethylsiloxane (PDMS) at various temperatures. Polym. Test. 2020, 90, 106670. [CrossRef]   
62. Gokaltun, A.; Yarmush, M.L.; Asatekin, A.; Usta, O.B. Recent advances in nonbiofouling PDMS surface modification strategies applicable to microfluidic technology. Technology 2017, 5, 1–12. [CrossRef] [PubMed]   
63. GRIFFITHS, E. international critical tables of numerical data, physics, chemistry and technology. Nature 1927, 119, 735–738. [CrossRef]   
64. Wu, M.H.; Urban, J.P.G.; Cui, Z.; Cui, Z.F. Development of PDMS microbioreactor with well-defined and homogenous culture environment for chondrocyte 3-D culture. Biomed. Microdevices 2006, 8, 331–340. [CrossRef] [PubMed]   
65. Tan, S.H.; Nguyen, N.T.; Chua, Y.C.; Kang, T.G. Oxygen plasma treatment for reducing hydrophobicity of a sealed polydimethylsiloxane microchannel. Biomicrofluidics 2010, 4, 032204. [CrossRef]   
66. Nakano, H.; Kakinoki, S.; Iwasaki, Y. Long-lasting hydrophilic surface generated on poly(dimethyl siloxane) with photoreactive zwitterionic polymers. Colloids Surf. B Biointerfaces 2021, 205, 111900. [CrossRef] [PubMed]   
67. Lee, J.N.; Park, C.; Whitesides, G.M. Solvent compatibility of poly(dimethylsiloxane)-based microfluidic devices. Anal. Chem. 2003, 75, 6544–6554. [CrossRef] [PubMed]   
68. Toepke, M.W.; Beebe, D.J. PDMS absorption of small molecules and consequences in microfluidic applications. Lab Chip 2006, 6, 1484–1486. [CrossRef] [PubMed]   
69. Bodas, D.; Khan-Malek, C. Hydrophilization and hydrophobic recovery of PDMS by oxygen plasma and chemical treatment-An SEM investigation. Sens. Actuators B Chem. 2007, 123, 368–373. [CrossRef]   
70. Makamba, H.; Kim, J.H.; Lim, K.; Park, N.; Hahn, J.H. Surface modification of poly(dimethylsiloxane) microchannels. Electrophoresis 2003, 24, 3607–3619. [CrossRef] [PubMed]   
71. Zhou, J.; Khodakov, D.A.; Ellis, A.V.; Voelcker, N.H. Surface modification for PDMS-based microfluidic devices. Electrophoresis 2012, 33, 89–104. [CrossRef] [PubMed]   
72. Hemmilä, S.; Cauich-Rodríguez, J.V.; Kreutzer, J.; Kallio, P. Rapid, simple, and cost-effective treatments to achieve long-term hydrophilic PDMS surfaces. Appl. Surf. Sci. 2012, 258, 9864–9875. [CrossRef]   
73. Trantidou, T.; Elani, Y.; Parsons, E.; Ces, O. Hydrophilic surface modification of pdms for droplet microfluidics using a simple, quick, and robust method via PVA deposition. Microsyst. Nanoeng. 2017, 3, 16091. [CrossRef]   
74. Yang, Y.; Kulangara, K.; Lam, R.T.S.; Dharmawan, R.; Leong, K.W. Effects of Topographical and mechanical property alterations induced by oxygen plasma modification on stem cell behavior. ACS Nano 2012, 6, 8591–8598. [CrossRef] [PubMed]   
75. Berdichevsky, Y.; Khandurina, J.; Guttman, A.; Lo, Y.-H. UV/ozone modification of poly(dimethylsiloxane) microfluidic channels. Sens. Actuators B Chem. 2004, 97, 402–408. [CrossRef]   
76. Hillborg, H.; Gedde, U.W. Hydrophobicity recovery of polydimethylsiloxane after exposure to corona discharges. Polymer 1998, 39, 1991–1998. [CrossRef]   
77. Makamba, H.; Hsieh, Y.Y.; Sung, W.C.; Chen, S.H. Stable permanently hydrophilic protein-resistant thin-film coatings on poly(dimethylsiloxane) substrates by electrostatic self-assembly and chemical cross-linking. Anal. Chem. 2005, 77, 3971–3978. [CrossRef]   
78. Boxshall, K.; Wu, M.-H.; Cui, Z.; Cui, Z.; Watts, J.F.; Baker, M.A. Simple surface treatments to modify protein adsorption and cell attachment properties within a poly(dimethylsiloxane) micro-bioreactor. Surf. Interface Anal. 2006, 38, 198–201. [CrossRef]   
79. Blättler, T.M.; Pasche, S.; Textor, M.; Griesser, H.J. High salt stability and protein resistance of poly(L-lysine)-g-poly(ethylene glycol) copolymers covalently immobilized via aldehyde plasma polymer interlayers on inorganic and polymeric substrates. Langmuir ACS J. Surf. Colloids 2006, 22, 5760–5769. [CrossRef]   
80. Xu, J.; Gleason, K.K. Conformal, amine-functionalized thin films by initiated chemical vapor deposition (iCVD) for hydrolytically stable microfluidic devices. Chem. Mater. 2010, 22, 1732–1738. [CrossRef]   
81. Zhang, Z.; Feng, X.; Xu, F.; Liu, X.; Liu, B.F. “Click” chemistry-based surface modification of poly(dimethylsiloxane) for protein separation in a microfluidic chip. Electrophoresis 2010, 31, 3129–3136. [CrossRef] [PubMed]   
82. Hu, S.; Ren, X.; Bachman, M.; Sims, C.E.; Li, G.P.; Allbritton, N.L. Surface-directed, graft polymerization within microfluidic channels. Anal. Chem. 2004, 76, 1865–1870. [CrossRef] [PubMed]   
83. Ariati, R.; Sales, F.; Souza, A.; Lima, R.A.; Ribeiro, J. Polydimethylsiloxane composites characterization and its applications: A review. Polymers 2021, 13, 4258. [CrossRef]   
84. Gökaltun, A.; Kang, Y.B.; Yarmush, M.L.; Usta, O.B.; Asatekin, A. Simple Surface Modification of Poly(dimethylsiloxane) via Surface Segregating Smart Polymers for Biomicrofluidics. Sci. Rep. 2019, 9, 97377. [CrossRef] [PubMed]   
85. Souza, A.; Souza, M.S.; Pinho, D.; Agujetas, R.; Ferrera, C.; Lima, R.; Puga, H.; Ribeiro, J. 3D manufacturing of intracranial aneurysm biomodels for flow visualizations: Low cost fabrication processes. Mech. Res. Commun. 2020, 107, 103535. [CrossRef]   
86. Santiago-Alvarado, A.; Cruz-Félix, A.S.; González-García, J.; Sánchez-López, O.; Mendoza-Jasso, A.J.; Hernández-Castillo, I. Polynomial fitting techniques applied to opto-mechanical properties of PDMS Sylgard 184 for given curing parameters. Mater. Res. Express 2020, 7, 45301. [CrossRef]   
87. Khanafer, K.; Duprey, A.; Schlicht, M.; Berguer, R. Effects of strain rate, mixing ratio, and stress–strain definition on the mechanical behavior of the polydimethylsiloxane (PDMS) material as related to its biological applications. Biomed. Microdevices 2008, 11, 503. [CrossRef]   
88. Prajzler, V.; Nekvindova, P.; Spirkova, J.; Novotny, M. The evaluation of the refractive indices of bulk and thick polydimethylsiloxane and polydimethyl-diphenylsiloxane elastomers by the prism coupling technique. J. Mater. Sci. Mater. Electron. 2017, 28, 7951–7961. [CrossRef]   
89. Lamberti, A.; Marasso, S.L.; Cocuzza, M. PDMS membranes with tunable gas permeability for microfluidic applications. RSC Adv. 2014, 4, 61415–61419. [CrossRef]   
90. Choi, J.S.; Piao, Y.; Seo, T.S. Fabrication of a circular PDMS microchannel for constructing a three-dimensional endothelial cell layer. Bioprocess. Biosyst. Eng. 2013, 36, 1871–1878. [CrossRef]   
91. Yoo, B.Y.; Kim, B.H.; Lee, J.S.; Shin, B.H.; Kwon, H.; Koh, W.G.; Heo, C.Y. Dual surface modification of PDMS-based silicone implants to suppress capsular contracture. Acta Biomater. 2018, 76, 56–70. [CrossRef]   
92. McMullan, D. Scanning electron microscopy 1928–1965. Scanning 1995, 17, 175–185. [CrossRef]   
93. Wong, B.; Zhang, Z.; Handa, Y.P. High-precision gravimetric technique for determining the solubility and diffusivity of gases in polymers. J. Polym. Sci. Part B Polym. Phys. 1998, 36, 2025–2032. [CrossRef]   
94. Goodwin, J.; Clark, C.; Deakes, J.; Burdon, D.; Lawrence, C. Clinical methods of goniometry: A comparative study. Disabil. Rehabil. 1992, 14, 10–15. [CrossRef] [PubMed]   
95. Schuh, C.A. Nanoindentation studies of materials. Mater. Today 2006, 9, 32–40. [CrossRef]   
96. Chong, H.; Lou, J.; Bogie, K.M.; Zorman, C.A.; Majerus, S.J.A. Vascular pressure-flow measurement using CB-PDMS flexible strain sensor. IEEE Trans. Biomed. Circuits Syst. 2019, 13, 1451–1461. [CrossRef] [PubMed]   
97. Boyce, M.C.; Arruda, E.M. An experimental and anaiytical investigation of the large strain compressive and tensile response of glassy polymers. Polym. Eng. Sci. 1990, 30, 1288–1298. [CrossRef]   
98. Fadley, C.S. X-ray photoelectron spectroscopy: Progress and perspectives. J. Electron. Spectrosc. Relat. Phenom. 2010, 178–179, 2–32. [CrossRef]   
99. Koenig, J.L. Fourier Transform Infrared Spectroscopy of Polymers BT—Spectroscopy: NMR, Fluorescence, FT-IR; Springer: Berlin/Heidelberg, Germany, 1984; pp. 87–154.   
100. Xia, Y.; Whitesides, G.M. Soft lithography. Angew. Chem. Int. Ed. 1998, 37, 550–575. [CrossRef]   
101. Catarino, S.O.; Rodrigues, R.O.; Pinho, D.; Miranda, J.M.; Minas, G.; Lima, R. Blood cells separation and sorting techniques of passive microfluidic devices: From fabrication to applications. Micromachines 2019, 10, 593. [CrossRef]   
102. Larson, R.G.; Rehg, T.J. Spin Coating BT. In Liquid Film Coating: Scientific Principles and Their Technological Implications; Kistler, S.F., Schweizer, P.M., Eds.; Springer: Dordrecht, The Netherlands, 1997; pp. 709–734.   
103. Akther, F.; Yakob, S.B.; Nguyen, N.-T.; Ta, H.T. Surface modification techniques for endothelial cell seeding in PDMS microfluidic devices. Biosensors 2020, 10, 182. [CrossRef]   
104. Morra, M.; Occhiello, E.; Marola, R.; Garbassi, F.; Humphrey, P.; Johnson, D. On the aging of oxygen plasma-treated polydimethylsiloxane surfaces. J. Colloid Interface Sci. 1990, 137, 11–24. [CrossRef]   
105. Xiong, L.; Chen, P.; Zhou, Q. Adhesion promotion between PDMS and glass by oxygen plasma pre-treatment. J. Adhes. Sci. Technol. 2014, 28, 1046–1054. [CrossRef]   
106. Liu, J.; Yao, Y.; Li, X.; Zhang, Z. Fabrication of advanced polydimethylsiloxane-based functional materials: Bulk modifications and surface functionalizations. Chem. Eng. J. 2021, 408, 127262. [CrossRef]   
107. Shin, S.; Kim, N.; Hong, J.W. Comparison of surface modification techniques on polydimethylsiloxane to prevent protein adsorption. BioChip J. 2018, 12, 123–127. [CrossRef]   
108. Zhao, Y.; Wen, J.; Ge, Y.; Zhang, X.; Shi, H.; Yang, K.; Gao, X.; Shi, S.; Gong, Y. Fabrication of stable biomimetic coating on PDMS surface: Cooperativity of multivalent interactions. Appl. Surf. Sci. 2019, 469, 720–730. [CrossRef]   
109. Jinia, A.J.; Sunbul, N.B.; Meert, C.A.; Miller, C.A.; Clarke, S.D.; Kearfott, K.J.; Matuszak, M.M.; Pozzi, S.A. Review of sterilization techniques for medical and personal protective equipment contaminated with SARS-CoV-2. IEEE Access 2020, 8, 111347–111354. [CrossRef] [PubMed]   
110. Linke, B. Sterilization Methods and Impact on Electronics in Medical Devices. 2011. Available online: https://www.eetimes.com/ document.asp?doc_id=1278906 (accessed on 20 September 2021).   
111. Harrington, R.E.; Guda, T.; Lambert, B.; Martin, J. Sterilization and Disinfection of Biomaterials for Medical Devices, 4th ed.; Elsevier: Amsterdam, The Netherlands, 2020.   
112. Tipnis, N.P.; Burgess, D.J. Sterilization of implantable polymer-based medical devices: A review. Int. J. Pharm. 2018, 544, 455–460. [CrossRef]   
113. Rogers, W.J. Sterilisation Techniques for Polymers; Elsevier Masson SAS: Issy-les-Moulineaux, France, 2012.   
114. Dai, Z.; Ronholm, J.; Tian, Y.; Sethi, B.; Cao, X. Sterilization techniques for biodegradable scaffolds in tissue engineering applications. J. Tissue Eng. 2016, 7, 2041731416648810. [CrossRef]   
115. Zhai, H.; Li, J.; Chen, Z.; Su, Z.; Liu, Z.; Yu, X. A glass/PDMS electrophoresis microchip embedded with molecular imprinting SPE monolith for contactless conductivity detection. Microchem. J. 2014, 114, 223–228. [CrossRef]   
116. Schöning, M.J.; Jacobs, M.; Muck, A.; Knobbe, D.T.; Wang, J.; Chatrathi, M.; Spillmann, S. Amperometric PDMS/glass capillary electrophoresis-based biosensor microchip for catechol and dopamine detection. Sens. Actuators B Chem. 2005, 108, 688–694. [CrossRef]   
117. Xu, K.; Clark, C.P.; Poe, B.L.; Lounsbury, J.A.; Nilsson, J.; Laurell, T.; Landers, J.P. Isolation of a low number of sperm cells from female DNA in a glass-PDMS-Glass microchip via bead-assisted acoustic differential extraction. Anal. Chem. 2019, 91, 2186–2191. [CrossRef]   
118. Hong, J.W.; Fujii, T.; Seki, M.; Yamamoto, T.; Endo, I. Integration of gene amplification and capillary gel electrophoresis on a polydimethylsiloxane-glass hybrid microchip. Electrophoresis 2001, 22, 328–333. [CrossRef]   
119. Xia, Y.-M.; Hua, Z.-S.; Srivannavit, O.; Ozel, A.; Gulari, E. Minimizing the surface effect of PDMS-glass microchip on polymerase chain reaction by dynamic polymer Passivation. J. Chem. Technol. Biotechnol. 2007, 82, 33–38. [CrossRef]   
120. Niu, Z.Q.; Chen, W.Y.; Shao, S.Y.; Jia, X.Y.; Zhang, W.P. DNA amplification on a PDMS-glass hybrid microchip. J. Micromech. Microeng. 2006, 16, 425–433. [CrossRef]   
121. Nandi, P.; Desai, D.P.; Lunte, S.M. Development of a PDMS-based microchip electrophoresis device for continuous online in vivo monitoring of microdialysis samples. Electrophoresis 2010, 31, 1414–1422. [CrossRef]   
122. Ha, B.H.; Destgeer, G.; Park, J.; Jung, J.H.; Sung, H.J. Generation of complex, dynamic temperature gradients in a disposable microchip. Phys. Procedia 2015, 70, 38–41. [CrossRef]   
123. Rodrigues, R.O.; Pinho, D.; Bento, D.; Lima, R.; Ribeiro, J. Wall expansion assessment of an intracranial aneurysm model by a 3D Digital Image Correlation System. Measurement 2016, 88, 262–270. [CrossRef]   
124. Fiddes, L.K.; Raz, N.; Srigunapalan, S.; Tumarkan, E.; Simmons, C.A.; Wheeler, A.R.; Kumacheva, E. A circular cross-section PDMS microfluidics system for replication of cardiovascular flow conditions. Biomaterials 2010, 31, 3459–3464. [CrossRef]   
125. Siddique, A.; Pause, I.; Narayan, S.; Kruse, L.; Stark, R.W. Endothelialization of PDMS-based microfluidic devices under high shear stress conditions. Colloids Surf. B Biointerfaces 2021, 197, 111394. [CrossRef]   
126. Lima, R.; Wada, S.; Tanaka, S.; Takeda, M.; Ishikawa, T.; Tsubota, K.I.; Imai, Y.; Yamaguchi, T. In vitro blood flow in a rectangular PDMS microchannel: Experimental observations using a confocal micro-PIV system. Biomed. Microdevices 2008, 10, 153–167. [CrossRef]   
127. Lima, R.; Oliveira, M.S.N.; Ishikawa, T.; Kaji, H.; Tanaka, S.; Nishizawa, M.; Yamaguchi, T. Axisymmetric polydimethysiloxane microchannels for in vitro hemodynamic studies. Biofabrication 2009, 1, 35005. [CrossRef] [PubMed]   
128. Nguyen, T.Q.; Park, W.-T. Fabrication method of multi-depth circular microchannels for investigating arterial thrombosis-on-achip. Sens. Actuators B Chem. 2020, 321, 128590. [CrossRef]   
129. Agrawal, S.; Paknikar, K.; Bodas, D. Development of immunosensor using magnetic nanoparticles and circular microchannels in PDMS. Microelectron. Eng. 2014, 115, 66–69. [CrossRef]   
130. Morarka, A.; Agrawal, S.; Kale, S.; Kale, A.; Ogale, S.; Paknikar, K.; Bodas, D. Quantum dot based immunosensor using 3D circular microchannels fabricated in PDMS. Biosens. Bioelectron. 2011, 26, 3050–3053. [CrossRef] [PubMed]   
131. Fujiwara, H.; Ishikawa, T.; Lima, R.; Matsuki, N.; Imai, Y.; Kaji, H.; Nishizawa, M.; Yamaguchi, T. Red blood cell motions in high-hematocrit blood flowing through a stenosed microchannel. J. Biomech. 2009, 42, 838–843. [CrossRef] [PubMed]   
132. Zeng, N.F.; Ristenpart, W.D. Mechanical response of red blood cells entering a constriction. Biomicrofluidics 2014, 8, 64123. [CrossRef] [PubMed]   
133. Faustino, V.; Catarino, S.; Pinho, D.; Lima, R.; Minas, G. A Passive microfluidic device based on crossflow filtration for cell separation measurements: A spectrophotometric characterization. Biosensors 2018, 8, 125. [CrossRef]   
134. Zhao, R.; Antaki, J.F.; Naik, T.; Bachman, T.N.; Kameneva, M.V.; Wu, Z.J. Microscopic investigation of erythrocyte deformation dynamics. Biorheology 2006, 43, 747–765.   
135. Lee, S.S.; Yim, Y.; Ahn, K.H.; Lee, S.J. Extensional flow-based assessment of red blood cell deformability using hyperbolic converging microchannel. Biomed. Microdevices 2009, 11, 1021–1027. [CrossRef]   
136. Pinho, D.; Yaginuma, T.; Lima, R. A microfluidic device for partial cell separation and deformability assessment. BioChip J. 2013, 7, 367–374. [CrossRef]   
137. Bento, D.; Sousa, L.; Yaginuma, T.; Garcia, V.; Lima, R.; Miranda, J.M. Microbubble moving in blood flow in microchannels: Effect on the cell-free layer and cell local concentration. Biomed. Microdevices 2017, 19, 6. [CrossRef]   
138. Bento, D.; Rodrigues, R.; Faustino, V.; Pinho, D.; Fernandes, C.; Pereira, A.; Garcia, V.; Miranda, J.; Lima, R. Deformation of red blood cells, air bubbles, and droplets in microfluidic devices: Flow visualizations and measurements. Micromachines 2018, 9, 151. [CrossRef]   
139. Shelby, J.P.; White, J.; Ganesan, K.; Rathod, P.K.; Chiu, D.T. A microfluidic model for single-cell capillary obstruction by Plasmodium falciparum-infected erythrocytes. Proc. Natl. Acad. Sci. USA 2003, 100, 14618–14622. [CrossRef]   
140. Boas, L.V.; Faustino, V.; Lima, R.; Miranda, J.M.; Minas, G.; Fernandes, C.S.V.; Catarino, S.O. Assessment of the deformability and velocity of healthy and artificially impaired red blood cells in narrow polydimethylsiloxane (PDMS) microchannels. Micromachines 2018, 9, 384. [CrossRef]   
141. Hou, H.W.; Li, Q.S.; Lee, G.Y.H.; Kumar, A.P.; Ong, C.N.; Lim, C.T. Deformability study of breast cancer cells using microfluidics. Biomed. Microdevices 2009, 11, 557–564. [CrossRef] [PubMed]   
142. Faustino, V.; Pinho, D.; Yaginuma, T.; Calhelha, R.C.; Ferreira, I.C.F.R.; Lima, R. Extensional flow-based microfluidic device: Deformability assessment of red blood cells in contact with tumor cells. BioChip J. 2014, 8, 42–47. [CrossRef]   
143. Faustino, V.; Rodrigues, R.O.; Pinho, D.; Costa, E.; Santos-Silva, A.; Miranda, V.; Amaral, J.S.; Lima, R. A microfluidic deformability assessment of pathological red blood cells flowing in a hyperbolic converging microchannel. Micromachines 2019, 10, 645. [CrossRef] [PubMed]   
144. Rodrigues, R.O.; Pinho, D.; Faustino, V.; Lima, R. A simple microfluidic device for the deformability assessment of blood cells in a continuous flow. Biomed. Microdevices 2015, 17, 108. [CrossRef]   
145. Rodrigues, R.O.; Bañobre-López, M.; Gallo, J.; Tavares, P.B.; Silva, A.M.T.; Lima, R.; Gomes, H.T. Haemocompatibility of iron oxide nanoparticles synthesized for theranostic applications: A high-sensitivity microfluidic tool. J. Nanopart. Res. 2016, 18, 194. [CrossRef]   
146. Bento, D.; Fernandes, C.S.; Miranda, J.M.; Lima, R. In vitro blood flow visualizations and cell-free layer (CFL) measurements in a microchannel network. Exp. Therm. Fluid Sci. 2019, 109, 109847. [CrossRef]   
147. Pinto, E.; Faustino, V.; Rodrigues, R.O.; Pinho, D.; Garcia, V.; Miranda, J.M.; Lima, R. A rapid and low-cost nonlithographic method to fabricate biomedical microdevices for blood flow analysis. Micromachines 2015, 6, 121–135. [CrossRef]   
148. Bento, D.; Lopes, S.; Maia, I.; Lima, R.; Miranda, J.M. Bubbles moving in blood flow in a microchannel network: The effect on the local hematocrit. Micromachines 2020, 11, 344. [CrossRef]   
149. Bento, D.; Pereira, A.I.; Lima, J.; Miranda, J.M.; Lima, R. Cell-free layer measurements of in vitro blood flow in a microfluidic network: An automatic and manual approach. Comput. Methods Biomech. Biomed. Eng. Imaging Vis. 2018, 6, 629–637. [CrossRef]   
150. Leble, V.; Lima, R.; Dias, R.; Fernandes, C.; Ishikawa, T.; Imai, Y.; Yamaguchi, T. Asymmetry of red blood cell motions in a microchannel with a diverging and converging bifurcation. Biomicrofluidics 2011, 5, 044120. [CrossRef]   
151. Ishikawa, T.; Fujiwara, H.; Matsuki, N.; Yoshimoto, T.; Imai, Y.; Ueno, H.; Yamaguchi, T. Asymmetry of blood flow and cancer cell adhesion in a microchannel with symmetric bifurcation and confluence. Biomed. Microdevices 2011, 13, 159–167. [CrossRef]   
152. Faustino, V.; Catarino, S.O.; Lima, R.; Minas, G. Biomedical microfluidic devices by using low-cost fabrication techniques: A review. J. Biomech. 2016, 49, 2280–2292. [CrossRef] [PubMed]   
153. Sadek, S.H.; Rubio, M.; Lima, R.; Vega, E.J. Blood Particulate Analogue Fluids: A Review. Materials 2021, 14, 2451. [CrossRef] [PubMed]   
154. Carvalho, V.; Maia, I.; Souza, A.; Ribeiro, J.; Costa, P.; Puga, H.; Teixeira, S.; Lima, R.A. In vitro biomodels in stenotic arteries to perform blood analogues flow visualizations and measurements: A review. Open Biomed. Eng. J. 2021, 14, 87–102. [CrossRef]   
155. Carvalho, V.; Gonçalves, I.M.; Souza, A.; Souza, M.S.; Bento, D.; Ribeiro, J.E.; Lima, R.; Pinho, D. Manual and automatic image analysis segmentation methods for blood flow studies in microchannels. Micromachines 2021, 12, 317. [CrossRef]   
156. Pinho, D.; Carvalho, V.; Gonçalves, I.M.; Teixeira, S.; Lima, R. Visualization and measurements of blood cells flowing in microfluidic systems and blood rheology: A personalized medicine perspective. J. Pers. Med. 2020, 10, 249. [CrossRef]   
157. Calejo, J.; Pinho, D.; Galindo-Rosales, F.J.; Lima, R.; Campo-Deaño, L. Particulate blood analogues reproducing the erythrocytes cell-free layer in a microfluidic device containing a hyperbolic contraction. Micromachines 2016, 7, 4. [CrossRef] [PubMed]   
158. Sun, H.; Björnmalm, M.; Cui, J.; Wong, E.H.H.; Dai, Y.; Dai, Q.; Qiao, G.G.; Caruso, F. Structure governs the deformability of polymer particles in a microfluidic blood capillary model. ACS Macro Lett. 2015, 4, 1205–1209. [CrossRef]   
159. Maruyama, O.; Yamane, T.; Nishida, M.; Aouidef, A.; Tsutsui, T.; Jikuya, T.; Masuzawa, T. Fractural characteristic evaluation of a microcapsule suspension using a rotational shear stressor. ASAIO J. 2002, 48, 365–373. [CrossRef] [PubMed]   
160. Carvalho, D.A.M.; Rodrigues, A.R.O.; Faustino, V.; Pinho, D.; Castanheira, E.M.S.; Lima, R. Microfluidic deformability study of an innovative blood analogue fluid based on giant unilamellar vesicles. J. Funct. Biomater. 2018, 9, 70. [CrossRef] [PubMed]   
161. Lima, R.; Vega, E.J.; Moita, A.S.; Miranda, J.M.; Pinho, D.; Moreira, A.L.N. Fast, flexible and low-cost multiphase blood analogue for biomedical and energy applications. Exp. Fluids 2020, 61, 231. [CrossRef]   
162. Merkel, T.J.; Jones, S.W.; Herlihy, K.P.; Kersey, F.R.; Shields, A.R.; Napier, M.; Luft, J.C.; Wu, H.; Zamboni, W.C.; Wang, A.Z.; et al. Using mechanobiological mimicry of red blood cells to extend circulation times of hydrogel microparticles. Proc. Natl. Acad. Sci. USA 2011, 108, 586–591. [CrossRef]   
163. Vilanova, N.; Rodríguez-Abreu, C.; Fernández-Nieves, A.; Solans, C. Fabrication of novel silicone capsules with tunable mechanical properties by microfluidic techniques. ACS Appl. Mater. Interfaces 2013, 5, 5247–5252. [CrossRef]   
164. Cui, J.; Björnmalm, M.; Liang, K.; Xu, C.; Best, J.P.; Zhang, X.; Caruso, F. Super-soft hydrogel particles with tunable elasticity in a microfluidic blood capillary model. Adv. Mater. 2014, 26, 7295–7299. [CrossRef]   
165. She, S.; Li, Q.; Shan, B.; Tong, W.; Gao, C. Fabrication of red-blood-cell-like polyelectrolyte microcapsules and their deformation and recovery behavior through a microcapillary. Adv. Mater. 2013, 25, 5814–5818. [CrossRef] [PubMed]   
166. Pinho, D.; Campo-Deaño, L.; Lima, R.; Pinho, F.T. In vitro particulate analogue fluids for experimental studies of rheological and hemorheological behavior of glucose-rich RBC suspensions. Biomicrofluidics 2017, 11, 54105. [CrossRef]   
167. Muñoz-Sánchez, B.N.; Silva, S.F.; Pinho, D.; Vega, E.J.; Lima, R. Generation of micro-sized PDMS particles by a flow focusing technique for biomicrofluidics applications. Biomicrofluidics 2016, 10, 014122. [CrossRef]   
168. Anes, C.F.; Pinho, D.; Muñoz-Sánchez, B.N.; Vega, E.J.; Lima, R. Shrinkage and colour in the production of micro-sized PDMS particles for microfluidic applications. J. Micromech. Microeng. 2018, 28, 75002. [CrossRef]   
169. Pinho, D.; Muñoz-Sánchez, B.N.; Anes, C.F.; Vega, E.J.; Lima, R. Flexible PDMS microparticles to mimic RBCs in blood particulate analogue fluids. Mech. Res. Commun. 2019, 100, 18–20. [CrossRef]   
170. Choi, Y.H.; Chung, K.H.; Hong, H.B.; Lee, W.S. Production of PDMS microparticles by emulsification of two phases and their potential biological application. Int. J. Polym. Mater. Polym. Biomater. 2018, 67, 686–692. [CrossRef]   
171. López, M.; Rubio, M.; Sadek, S.H.; Vega, E.J. A simple emulsification technique for the production of micro-sized flexible powder of polydimethylsiloxane (PDMS). Powder Technol. 2020, 366, 610–616. [CrossRef]   
172. Carneiro, J.; Lima, R.; Campos, J.B.L.M.; Miranda, J.M. A microparticle blood analogue suspension matching blood rheology. Soft Matter 2021, 17, 3963–3974. [CrossRef] [PubMed]   
173. Lima, R.; Vega, E.J.; Cardoso, V.F.; Minas, G.; Montanero, J.M. Magnetic PDMS Microparticles for Biomedical and Energy Applications BT—VipIMAGE; Tavares, J.M.R.S., Natal Jorge, R.M., Eds.; Springer International Publishing: Cham, Switzerland, 2019; pp. 578–584.   
174. Barthes, J.; Lagarrigue, P.; Riabov, V.; Lutzweiller, G.; Kirsch, J.; Muller, C.; Courtial, E.-J.; Marquette, C.; Projetti, F.; Kzhyskowska, J.; et al. Biofunctionalization of 3D-printed silicone implants with immunomodulatory hydrogels for controlling the innate immune response: An in vivo model of tracheal defect repair. Biomaterials 2021, 268, 120549. [CrossRef]